-- Define our particle characteristics
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a Vec2 velocity member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member

-- Set the particle texture
SetTexture("heartboost");
SetBlendMode(kBlendNormal);

SetNumParticles(20);    -- Create some particles

pPosition:Init(  Vec2(0,0) );
pVelocity:Init( fRange( Vec2(40,200), Vec2(-40,100) ) );
pColor:Init( Color(1,1,1,1) );
pScale:Init( 0.5 );
pSpin:Init( fRange( 0, 1.5 ) );
pSpinSpeed:Init( fRange( -5, 5 ) );
pUp:Anim( f2dRotation( pSpin ) );

kLifetime = 400;
pColor:Anim( fFade( pAge,Color(1,1,1,1), kLifetime, Color(1,1,1,0) ) );
pPosition:Anim( pPosition + fTimeScale(pVelocity) );
pPosition:Anim( pPosition );
pScale:Anim( pScale + fTimeScale(1) );

pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

-- Add time to the age
pAge:Anim( pAge+fAge() );

-- Expire particles over 1500 ms old
Anim( fExpire( fGreater(pAge,kLifetime) ) );



-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   -- Create 10 particles per second
    CreateParticles( seconds * 10 );
end

